VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function DeleteFile Lib "kernel32" Alias "DeleteFileA" (ByVal lpFileName As String) As Long
Private Declare Function GetTempFileName Lib "kernel32" Alias "GetTempFileNameA" (ByVal lpszPath As String, ByVal lpPrefixString As String, ByVal wUnique As Long, ByVal lpTempFileName As String) As Long
Private Declare Function MoveFileEx Lib "kernel32.dll" Alias "MoveFileExA" (ByVal lpExistingFileName As String, ByVal lpNewFileName As String, ByVal dwFlags As Long) As Long
Const MOVEFILE_COPY_ALLOWED = &H2
Const MOVEFILE_WRITE_THROUGH = &H8

Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

Private Function RemoveNulls(ByRef Str As String)
   Dim pos As Integer
   pos = InStr(Str, Chr$(0))
   If pos Then
      Str = Left$(Str, pos - 1)
   End If
End Function

Function SignFile(InFileName As String, OutFileName As String, FieldName As String, Reason As String, PosX As Double, VisibleSignature As Boolean) As Boolean
   Dim FilePath As String
   Dim outName As String

   SignFile = False

   outName = OutFileName
   If InFileName = OutFileName Then
      FilePath = String(260 + 1, Chr$(0))
      If GetTempFileName(".", vbNullString, 0, FilePath) = 0 Then Exit Function
      Call RemoveNulls(FilePath)
      outName = FilePath
   End If
   Call pdf.CreateNewPDF(outName)

   ' Adding multiple signatures with a demo version of DynaPDF couldn't work since a demo string would
   ' be added to each page that was edited Or changed And this would invalidate previous signatures.
   pdf.SetLicenseKey ("SigDemo")

   ' This flag also sets the flags ifImportAsPage | ifImportAll, and if2UseProxy | if2CopyEncryptDict to make sure that
   ' anything is imported and nothing gets changed.
   Call pdf.SetImportFlags2(TImportFlags2.if2IncrementalUpd)
   If pdf.OpenImportFile(InFileName, TPwdType.ptOpen, vbNullString) < 0 Then Exit Function
   Call pdf.ImportPDFFile(1, 1#, 1#)

   If VisibleSignature Then
      Call pdf.SetPageCoords(TPageCoord.pcTopDown)
      Call pdf.EditPage(1)
         Dim sig As Long
         sig = pdf.CreateSigField(FieldName, -1, PosX, 30#, 180#, 40#)
         Call pdf.SetFieldBorderWidth(sig, 0#)
      Call pdf.EndPage
   End If
   SignFile = pdf.CloseAndSignFile("../../../test_files/test_cert.pfx", "123456", Reason, vbNullString)
   If SignFile Then
      If outName = FilePath Then
         Call DeleteFile(OutFileName)
         Call MoveFileEx(outName, OutFileName, MOVEFILE_COPY_ALLOWED Or MOVEFILE_WRITE_THROUGH)
      End If
   End If
End Function

Private Sub Command1_Click()
   Dim reply As Long

   ' We write the output file into the current directory.
   Dim FilePath As String
   FilePath = App.Path + "\out.pdf"

   ' We sign the file 4 times in this example. We add two visible and two invisible signatures.
   If SignFile("../../../../license.PDF", FilePath, "Signature1", "Test signature 1", 50#, True) Then
      If SignFile(FilePath, FilePath, "Signature2", "Test signature 2", 430#, True) Then
         If SignFile(FilePath, FilePath, vbNullString, "Test signature 3", 0#, False) Then
            If SignFile(FilePath, FilePath, vbNullString, "Test signature 4", 0#, False) Then
               ShellExecuteA Me.hWnd, "open", FilePath, vbNullString, vbNullString, 1
            End If
         End If
      End If
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
